::: info
__Légende pour la suite:__

Écrit comme ça, c'est destiné aux participant·es

*Écrit comme ça, c'est ce qui peut être enlevé facilement si on veut raccourcir le temps d'atelier.*

**\[ Écrit comme ça, c'est des infos pour la/les personne(s) qui anime(nt). \]**

:::

## Le déroulé

**\[ Tout ça c'est les différentes phases de l'atelier, sans compter les pauses, etc. :** 

 1. **Présentation du module, des objectifs, du cadre de confiance du module.**
 2. **Temps théorique : Les bases d'internet**
 3. **Jeu**
 4. **Temps théorique : VPN**
 5. **Jeu**
 6. **Temps théorique : Tor**
 7. **Jeu**
 8. **Temps théorique : Tails**
 9. **Jeu**
10. **Temps théorique : Mails et chiffrement PGP**
11. **Jeu**
12. **Conclusion \]**

# Introduction

Dans ce module on va aborder des trucs de base d'ordi et d'internet. L'informatique c'est compliqué, c'est donc normal qu'on ne retienne pas tout, normal que ce soit dur à comprendre.

On va faire des raccourcis à plein de moments, le but est pas de transmettre des connaissances exhaustives (on ne pourrait pas le faire en 8h ni en 100).

Aussi, y a pas de question bête, on est pas là pour se la péter ou mettre en avant ses connaissances, on est là pour partager et comprendre.

Pour celleux qui veulent creuser le sujet, on propose une affiche pour se partager des ressources sur les sujets informatiques ou vous pouvez noter vos références, bouquins, sites, podcasts, assos...

**\[ Cette affiche elle peut être collée quelque part, ou à faire tourner à la fin, etc. \]**

Cet atelier se base beaucoup sur le guide d'autodéfense numérique dans les définitions. Il est accessible sur https://guide.boum.org/

Ça peut être super anxiogène de capter tout ce qu'on risque avec ces usages, donc hésitez pas à sortir si besoin, nous reposer des questions pendant, après.

Un dernier point, on ne présume pas du nom ou du pronom des gens. On peut écouter comment les gen·tes se pronomment et/ou on peut leur demander si besoin. Ou alors on se débrouille pour interpeller les gens sans utiliser de blaze et on ne met pas de genre dans nos phrases, mais ça peut être moins facile.

Pour la suite, on va alterner théorie descendante et jeu plus ludique. N'hésitez pas à poser des questions quand vous voulez, mais parfois faudra avancer pour le bon déroulement de l'atelier, désolé·e d'avance des frustrations occasionnées.

Ce n'est pas un atelier dans lequel on va faire de la pratique, parce que c'est impossible de tout faire. Hésitez pas à organiser des ateliers pratiques ou chercher des gens qui savent faire pour pouvoir aller plus loin si vous avez des besoins.

## Scénario fil rouge :

Tout au long de cet atelier on va suivre une histoire comme fil rouge, et voir ce qu'il se passe pour les différents personnages de l'histoire.

**\[ Scénario à créer au choix, et à imaginer parmi les trucs que les flics aiment vraiment pas pour plus de réalisme, on vous donne un exemple de ce qui peut marcher: \]**

Une cimenterie a été dégradée pendant la nuit. Un communiqué a été publié et largement relayé sur les réseaux numériques par un groupe se revendiquant du désarmement. Une enquête est ouverte. On va suivre l'histoire de 4 personnages qui sont liés à cette affaire.

__POINT IMPORTANT :__ Par souci pédagogique, on part du principe que les choses se passent mal, pour explorer les pires des cas. C'est à dire que dans notre atelier, la police n'est pas omnisciente, et elle a les pouvoirs qu'elle a dans la vraie vie. Par contre, elle est très efficace : il n'y a pas de dysfonctionnements dans ses enquêtes comme c'est le cas en réalité, les papiers se perdent pas, personne n'est en vacances, il n'y a pas de fausses manips ou de bug des logiciels, bref, tout roule pour elleux.

# Partie 1

## **Théorie :** bases du fonctionnement d'internet

::: info
À aborder : ordinateur, libre/open source/propriétaire, internet, serveur, routeur, fournisseur de services, FAI, navigateur web, adresse IP, nom de domaine, annuaire DNS, requête DNS, HTTP/HTTPS, chiffrement

:::

### Qu'est ce qu'un **ordinateur** ?

Un ordinateur est un ensemble de composants plus ou moins complexes reliés entre eux par des connexions électriques, des câbles et parfois des ondes. Il traite des informations variées.

L'ordinateur auquel on pense toustes c'est l'ensemble écran - clavier - tour, ou bien un ordinateur portable ou tout est fixé ensemble.

Il existe cependant d'autres ordinateurs si on suit cette définition, vous avez des idées?

Ex : un téléphone portable (un téléphone à boutons est un ordinateur un peu "nul", un smartphone est beaucoup plus puissant), une "box" de connexion à internet, un compteur Linky, une imprimante, un routeur...

#### ***Les éléments importants d'un ordi :*** 

##### *Les éléments matériels :* 

* *la __carte mère__ relie les composants électroniques d'un ordinateur entre eux et leur permet de fonctionner. Parmi eux :* 
* *le __processeur__ est la 'calculatrice' qui traite les informations, elle ordonne et exécute les instructions qui lui sont données.*
* *la __mémoire vive ou RAM__ : c'est là que sont stockés tous les trucs ouverts sur l'ordi quand il fonctionne. Elle est limitée, et c'est pour ça que si tu allumes tous tes logiciels en même temps, ça peut planter. Les informations accumuléesn dessus pendant que l'ordi fonctionne disparaissent une fois l'ordinateur éteint.*
* *le __disque dur ou mémoire persistante__ : c'est l'endroit où l'ordi stocke les logiciels et les données pour qu'elles restent quelque part même après avoir éteint l'ordinateur.*
* *des __entrées__ et des __sorties__ (port usb, wifi, jack, ethernet...)*

##### *Les éléments logiciels :* 

* *le __système d'exploitation__, est un programme qui coordonne un ensemble de programmes, qui ensemble font tourner un ordinateur (ex de système d'exploitation : Windows, MacOS, Android, Linux (Ubuntu, Debian), GrapheneOS...).*
* *les __logiciels ou applications__, sont des programmes concus pour faire une chose précise (qui peut être très complexe cependant).*

### Outil **"propriétaire"** vs outil "**libre" ou "open-source"**

Un point important avant de continuer, c'est la différence entre les outils '__propriétaires__' et '__libre'__ ou '__open source'__.

La différence entre les 3 termes, c'est le niveau de contrôle que les personnes peuvent plus ou moins exercer sur l'outil.

- Les ordinateurs sont des outils complexes (de plus en plus), fabriqués par des entreprises en concurrence dont le but est surtout de tirer profit de leur activité. La 'recette' de fabrication d'un ordi n'est pas souvent révélée, ou alors seulement partiellement (pour certains composants par exemple). C'est privatif__,__ __propriétaire__. Skype, Windows ou WhatsApp sont des logiciels propriétaires par exemple.
- __Open-source__ (ou source ouverte en français) : ça veut dire que la recette est accessible, on peut voir ce que peut faire le logiciel, mais il peut y avoir des contraintes sur son utilisation ou être, en pratique, sous le contrôle fort d'une entreprise peu sympathique (Chrome par exemple)
- __Libre__, ça voudrait dire qu'on donne la recette, et qu'on permet aussi la reproduction et la modification de l'outil. Mumble, Linux ou Signal sont des logiciels libres, par exemple.   
  /!\\ Un outil libre est donc par définition open source, mais l'inverse n'est pas vrai!

### Alors, c'est quoi tous ces trucs de **Internet** ?

#### **Internet**

C'est un ensemble d'ordinateurs reliés entre eux par des câbles et des ondes (entre les continents, internet c'est des très gros et très longs câbles !).  
Ces câbles et ondes sont principalement gérés par des fournisseur d'accès à Internet (FAI).

#### Un **serveur**

C'est un ordinateur auquel notre ordi se connecte via internet pour lui demander des informations. Il stocke des données auxquelles on peut vouloir accéder (par exemple le serveur de wikipédia stocke le contenu de ses pages, le serveur de notre boîte mail stocke nos mails, ...)

#### Un **routeur**

C'est un ordinateur qui fait transiter de l'information. Une box internet à la maison par exemple, c'est un routeur, elle reçoit des informations qu'elle transfère ailleurs. Mais ça peut aussi être un ordinateur situé sur le chemin entre ton ordi et le serveur sur lequel est stocké le site que tu veux aller voir.

Quand on "navigue" sur Internet, on passe par un certain nombre de routeurs sans le choisir forcément (notre ordinateur n'est pas directement branché avec un câble au serveur États-Uniens qui héberge le site qu'on veut voir! Il doit par exemple forcément passer par un des routeurs qui sont branchés aux câbles qui traversent l'océan, ...).

Ils peuvent au passage techniquement enregistrer une information (données ou métadonnées de connexion, on verra ce que c'est plus tard), mais c'est pas du tout automatique.

#### Un **fournisseur de service** 

Une entité (individu·e, association, entreprise) qui propose un service : fournisseur de mail, fournisseur de serveur, fournisseur d'accès à Internet, fournisseur de blogs, fournisseur de messagerie instantanée...

#### Un **fournisseur d'accès à internet (FAI)**

C'est un type de fournisseur de service dont le but est de permettre à ses abonné·e·s d'accéder à Internet. Il y en a des privés (Orange, Free...), et des associatifs (FDN, FAI maison, ...).

#### *Un **"cloud"***

***En gros 'avoir un cloud', c'est avoir tes données qui sont sur le serveur de quelqu'un·e d'autre, entreprise, asso ou personne.***

*__Le__ cloud, c'est une autre manière de désigner l'Internet, on peut dire que c'est spécifiquement l'ensemble des serveurs qui stockent des données.*

*__Un__ cloud, c'est un espace de stockage de données externalisé, pour que ça soit conservé dans un data center (centre de stockage de données) plutôt que sur ton ordinateur personnel. Ça permet de partager des données (documents, images, etc.) entre plusieurs ordis, sans avoir chez soi une machine qu'il faut faire tourner h-24, connectée à Internet et qu'on ne sait/veux pas entretenir ou réparer nous-mêmes. Des entreprises proposent ce service de stockage : Dropbox, OneDrive, NextCloud, ...*

#### Un **navigateur web**

Dans un ordinateur, il y a le matériel, mais aussi tout ce qui est immatériel. Les logiciels, on l'a dit, sont des programmes conçus pour faire une chose précise (qui peut être très complexe cependant). Est ce que vous pensez à des exemples de logiciels ?

Exemples : libreoffice, visionneur de PDF, Linux (qui est un système d'exploitation (comme Windows, MacOS, Android, ...) : c'est un gros logiciel qui sert à coordonner, faire marcher les autres logiciels qu'il y a dedans), Thunderbird, ... 

Et donc un navigateur web, c'est un logiciel qu'on a sur l'ordi ou le tél, qui nous permet de visiter des sites web, tels que wikipedia.org, mail.riseup.net, indymedia.org, duckduckgo.com, google.fr…

Les plus connus des navigateurs web sont Google Chrome, Firefox, Safari. Mais il y en a pleins d'autres, plus ou moins propriétaires, plus ou moins open source, plus ou moins libres. On y reviendra.

#### Comment les ordinateurs communiquent ensemble?

__Donnons plutôt un exemple :__

Si on ouvre son navigateur web, et qu'on clique sur le favoris "Infokiosques", qui charge le site web "https://infokiosques.net" et nous l'affiche à l'écran : que se passe-t-il dans les coulisses du réseau ?

"infokiosques.net" est appelé "__nom de domaine__", et a été inventé pour être mémorisable par l'humain. Mais les machines ne savent pas communiquer entre elles avec des noms comme ça : il leur faut des adresses, appelées "__adresse IP__" (*pour* *internet protocol),* mais qui sont vachement moins simples à retenir qu'un nom de domaine. Au final, l'IP et le nom de domaine c'est un peu comme une adresse postale (2 rue de l'église 44220 La Montagne par exemple), mais dans 2 langues différentes, une en français et l'autre en langage informatique.

Pour pouvoir se trouver et communiquer ensemble, tous les ordinateurs, quels qu'ils soient, se voient attribuer une adresse IP (la box en a une pour communiquer avec les autres routeurs sur internet, ou les ordinateurs en ont une pour pouvoir communiquer avec la box, etc.).

*Une adresse IP (traditionnelle) c'est une série de chiffres qui vont de 0.0.0.0 à 256.256.256.256 max. C'est limité donc ils en ont inventé des plus complexes avec des lettres (IPv6), encore moins faciles à retenir.*

*Il existe donc des annuaires qui permettent d'obtenir l'adresse IP d'une machine à partir de son nom de domaine : les __annuaires DNS__ (aussi appelés Serveurs DNS)*

*La première chose que l'ordi fait quand on va sur https://infokiosques.net, c'est de demander à un annuaire l'adresse correspondante : ça s'appelle une __requête DNS__.*

*On peut choisir un annuaire DNS et dire à notre ordinateur d'utiliser tel ou tel serveur, mais en général la box à laquelle on connecte notre ordi envoie les adresses IP de ses propres annuaires (ceux du Fournisseur d'Accès Internet).*

*Si jamais c'est une requête __HTTP__ : tout passe en clair partout où ça passe (pas de chiffrement), c'est à dire que sur chaque ordinateur (routeur, serveur, ...) ou passe l'information, on peut techniquement voir l'information en détail (par exemple le nom du blog, la page précise où vous êtes, le contenu du commentaire posté sur cette page, ...).*

*__HTTPS__ c'est une manière de communiquer de l'information qui fait que le contenu des échanges est chiffré. En gros, la seule information qu'un observateur extérieur (FAI / police / hacker) va normalement voir quand on fait une requête HTTPS c'est l'adresse elle-même, avant le 1er slash. Pas le contenu du commentaire que vous envoyez, pas le détail du site visité. Par exemple, https://infokiosques.net/anarchie, l'observateur ne voit pas /anarchie ou la référence précise d'un texte consulté qui montrerait un intérêt spécifique.*

### Ça veut dire quoi **chiffrement** ?

\-> C'est rendre une information illisible aux personnes n'ayant pas les clés pour la lire.

C'est remplacer temporairement une information par une suite de chiffres et de lettres qui n'ont de logique que si l'on a la clé pour faire la traduction inverse.

En informatique : c'est utilisé pour augmenter la confidentialité d'une communication (l'accès que les tiers ont à une info), et potentiellement minimiser la surface d'attaque (par quels bouts, par quel endroit les tiers ont accès à une info).

Par exemple dans nos recherches internet, si le lien qu'on regarde commence par **httpS** plutôt que **http**, ça fait que sur les routeurs intermédiaires ou sur les serveurs des FAI, on ne verra pas une recherche de textes sur l'anarchie, mais juste qu'on veut se connecter à infokiosques.net. Hyper cool.

**\[ C'est possible pendant cette partie d'afficher le chemin d'un ordi à un site, pour commencer à voir les différents intermédiaires (ordi/box/FAI/grand internet avec plein de serveurs intermédiaires inconnus/serveur désiré). Ça peut servir de repère visuel pendant les corrections, pour avoir un autre type de schéma auquel se raccrocher, et c'est pas mal pour la partie Tor. D'expérience, ça ne gâche pas l'effet du jeu qui suis, mais ça dépend du niveau des personnes, aussi. \]**

## **Jeu** : Nando se connecte à internet

### Scénario

Dans notre histoire, on suit les actions d'un premier personnage: Nando, qui se connecte à internet, va sur *nantes.indymedia.org*, trouve un communiqué qu'elle republie sur facebook.

Voici des cartes. L'objectif c'est que chaque groupe arrive à les positionner dans l'ordre de connexion autour de la feuille du grand internet, et puisse dessiner le chemin des différentes connexions **\[ par exemple avec un feutre à tableau si on a plastifié les cartes \]**.

### Cartes

**\[ Donner les petits paquets de 5 cartes infrastructures mélangées. \]**

1. **ordi perso Nando**
2. **box Nando**
3. **FAI Orange**
4. **serveur Indy Nantes**
5. **serveur Facebook**

   **(câbles/ondes (feutres))**

### **Correction**

**\[ Affichage au mur (avec des cartes au grand format par exemple) (voir le schéma corrigé) \]**

## **Quelles données sont accessibles pour la police ?**

On a en tête que ce peut être des policiers dans le cadre d'une enquête judiciaire ou des policiers du renseignement, qui ont donc des pouvoirs différents, mais pour l'exercice on va juste parler de flics et ne pas faire la différence entre les deux, on prend toutes leurs possibilités d'actions.

Les policiers peuvent faire des requêtes pour obtenir des informations, lesquelles à votre avis?

**\[ Laisser quelques minutes de réflexion, et distribuer les cartes infos flics pendant qu'iels papotent. \]**

### **Correction**

**\[ Si les réponses sont affichées au mur par exemple, ajouter les données en dessous des grosses cartes (uniquement les données auquelles la police peut avoit accès) \]**

__RAPPEL :__ Les flics ne sont pas surpuissants/ont leurs limites humaines et matérielles et donc l'accès aux infos dépend de leurs moyens, du bon vouloir de certains acteurs, de si l'info est disponible par ailleurs, de leurs erreurs, ...

- __Via nantes.indymedia.org:__
  - rien (sauf si le serveur est compromis par ladite police, auquel cas iels pourraient obtenir l'adresse IP de nando, mais c'est improbable)
- __Via facebook:__
  - Le communiqué a été publié par Nando Karimata, le 8/05/2020 à 8h29 depuis l'adresse IP 92.169.148.17 (Orange).
  - Le compte de Nando a été créé le 20/06/2014 depuis l'adresse IP 92.169.112.121

    L'adresse email associée est n.karimata@gmail.com.
  - Le user-agent utilisé pour publier le communiqué: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1823.51".
  - La liste des amis fb est la suivante : ... / ... / ... / blabla
  - D'autres infos possibles, dernières connexions, images publiées, messages persos échangés si réquisitionnés...
- __Via le FAI Orange :__

  Une fois que les flics ont l'IP, iels savent à quel FAI demander, et le FAI peut donner très rapidement (*automatisé via la "PNIJ"*) l'adresse associée à l'abonnement (et potentiellement d'autres infos, bancaires, etc.). Il peut aussi fournir la liste des ordis connectés à la livebox les 12 derniers mois
  - Le compte Orange associé à l'IP 92.169.148.17 au 8/05/2020 est celui de Nando Karimata, résidant 13 rue des Makrouts 22240 Plurien
  - Si les flics insistent un peu, il peut être possible d'obtenir les identifiants matériel (MAC) et les nom des machines connectées à la box ce dernier mois (voire les 12 derniers mois) (voire depuis qu'elle a sa livebox)
- __Risques supplémentaires en cas de perquisition / accès physique :__

  On en parle plus tard

# Partie 2

## **Théorie** : Fournisseurs de services & VPN

On l'a dit tout à l'heure, un fournisseur de service c'est une entité qui propose un service. C'est un terme très large pour parler de pleins de trucs. Par exemple, Indymedia ou Facebook en sont, mais ils ne font pas les mêmes choses du tout. Il y a des sous-catégories qu'on peut envisager, mais là encore avec des différences en leur sein : il y a les FAI (SFR, Xankom en Bretagne, FDN), les fournisseurs de mails (Gmail, Protonmail, Autistici), les navigateurs web (Chrome, Firefox, Tor), les clouds (OVHCloud, GoogleDrive, Nextcloud), les hébergeurs de contenus (Youtube, Bandcamp, Indymedia), les VPN (NordVPN, Proton VPN, Riseup VPN).

Tout dépend de la confiance qu'on va mettre dans l'entité qui fournit le service et des garanties qu'elle offre. Est-ce une entreprise ? Est-ce une association ? Est-ce qu'elle a une bonne réputation ? Selon quels critères ? Est-ce que le service est administré (=entretenu) ? Est-ce qu'une communauté vérifie ce qui est fait avec l'outil proposé ? Quel est l'intérêt du fournisseur de me proposer ce service (économique, politique, militant...) ? Donc si on répond à toutes ces questions, non, Facebook et Indymedia, ce n'est pas pareil.

Les annuaires de DNS et les hébergeurs de sites web sont aussi des fournisseurs de service.

#### **VPN**

Un VPN (Virtual Private Network), réseau privé virtuel, permet de changer les adresses IP d'une connexion Internet en créant un lien direct entre un ordinateur et le serveur du fournisseur de VPN. Plutôt que l'adresse de ta box, c'est une des adresses du VPN qui sera transmise au fournisseur de service. Donc toustes les utilisateurices de ce service VPN auront la même adresse de connexion (rattachable au VPN), du point de vue des services internet auxquels on se connecte.

Exemple : Je vais sur mon ordi connecté à un VPN sur youtube, et je regarde des vidéos de manif : et bien mon FAI (Free par exemple) verra uniquement que je vais visiter l'adresse de mon VPN. Et youtube verra que l'origine de la demande pour voir cette vidéo, c'est le VPN.

**\[ Plus ou moins faire un schéma avec ce qui est déjà affiché si c'est pas clair, ça aide vachement. \]**

Utiliser un VPN peut rendre plus difficile pour un attaquant l'obtention de l'adresse IP d'origine d'une requête vers un site web par exemple. Si un pirate informatique ou un service de renseignement étatique essaye de savoir qui s'est connecté sur infokiosques.net, il peut voir qu'une personne a utilisé un VPN (analyser les connexions internet allant au serveur et en recherchant l'IP, il peut voir que ça appartient à tel VPN).

Le VPN permet aussi de contourner la censure *par "géoblocage"* (*geoblocking - bloquer les connexions d'adresse IP émanant de pays particuliers)*, puisque les demandes n'émaneront pas du pays dans lequel je suis mais du pays où mon VPN est situé.

Mais un VPN ne permet pas d'être anonyme, il déplace juste le problème : plutôt que ce soit le FAI qui ait les informations, ce sera le VPN, d'où la question à se poser de la confiance qu'on a en le fournisseur de service choisi.

*Le fournisseur VPN est, dans la chaine de connexion et ce qu'on envisage ici, le premier acteur que l'on choisit réellement. Dans les étapes d'avant on se connecte à un site web et à un fournisseur DNS, mais ça ne ressemble pas à "choisir un fournisseur". Avec l'utilisation d'un VPN, on est obligé⋅e de __choisir__ un fournisseur (Riseup, Calyx, Mullvad…).*

## **Jeu** : Gigi utilise un VPN

### Scénario

Notre personnage suivant, c'est Gigi, qui se connecte à son VPN, va sur facebook, trouve le communiqué et le publie sur son blog wordpress.

À savoir que « Gigi » est un nom d'usage, non lié à son état-civil.

### Cartes

Voici des cartes supplémentaires à positionner !

1. **ordi perso Gigi**
2. **box Gigi**
3. **FAI Bouygues**
4. **serveur NordVPN**

   ***serveur facebook  (déjà sur place)***
5. **serveur wordpress.com**

   **(Câbles/ondes (feutres))**

### **Correction**

**\[ Affichage au mur (avec des cartes au grand format par exemple) (voir le schéma corrigé) \]**

## **Quelles données concernant gigi sont accessibles pour la police ?**

**\[ Au mur, ajouter les données en dessous des grosses cartes (uniquement les données auxquelles la police peut avoit accès), données qui sont personnalisées pour les personnages. \]**

- Wordpress.com: 
  - blog géré par gigi@proton.me, créé le 13 décembre 2019, depuis l'adresse IP 37.120.213.107 (nordVPN).
  - Derniers articles publiés depuis ces adresses IP : 91.132.136.67 (nordVPN), 91.132.136.75 (nordVPN), le communiqué en question a été publié le 8/05/2020 à 9h47 depuis l'adresse IP 146.70.26.83 (nordVPN)
- Facebook: 
  - gigi@proton.me a bien un compte facebook et a accedé au communiqué le 8/05/2020 à 9h09, depuis l'adresse IP 146.70.26.83 (NordVPN)
  - \+ autres informations concernant "gigi"
- VPN (peu probable et selon le fournisseur VPN) : 
  - on sait qu'entre 9h41 et 9h52, le compte associé à gigi@proton.me utilisait cette adresse IP et est allé sur facebook et un blog wordpress <https://gigi.wordpress.com>.
  - L'utilisateurice était connecté⋅e au VPN depuis l'adresse IP 176.174.232.41 (Orange)
- FAI de gigi: 
  - l'adresse IP 176.174.232.41 était attribuée à Kévin Leseum.
  - Sa box internet était bien connectée à un VPN à ces heures.
  - Voici son nom, son adresse : ....
- Saisie de l'ordi : on en parle plus tard

# Partie 3

## **Théorie** : Tor

##### Explication Tor

**\[ Là, la proposition, c'est d'expliquer Tor avec une explication simplifiée visuelle. Pour faire cette présentation, y a besoin de 3 boites de plus en plus grosses (type poupées russes) (ça peut être juste 3 enveloppes recoupées, ou des boites en carton plus stylées, mais pas obligé d'être un truc de ouf quoi), d'une table et de quelques feuilles de papier.**

**Sur la plus grosse boite/enveloppe, marque "Expéditeur : moi / destinataire: Noeud Tor 1"**  
**Sur la moyenne, marque "expéditeur : Noeud Tor 1 / Destinataire : Noeud Tor 2"**  
**Et sur la petite, marque "expéditeur : Noeud tor 2 / Destinataire : noeud tor 3"**

**Sur l'une des feuilles, marque "navigateur tor", et tu la mets à un bout de la table (de façon à ce que les gens la voie) et sur l'autre 'truc.fr', posée à l'autre bout de la table (de façon à ce que les gens la voie). Entre les 2, pose "Noeud tor 1", "Noeud tor 2", et "noeud tor 3".**

**Sur une petite feuille, fais une carte postale avec écrit au niveau de l'adresse "truc.fr" et au niveau du texte ce que tu veux qui ressemble à peu près à "Salut, tu peux me donner ta page d'accueil? Signé : Noeud Tor 3".**

**Sur une autre petite feuille, écrire "Page d'accueil de truc.fr". \]**

##### **Intro:**

Tor, c'est un réseau de serveurs, qui permet à son navigateur, le navigateur tor, de naviguer sur internet en diminuant énormément les chances de faire le lien entre la personne qui utilise le navigateur et les sites qui sont visités. Pour ça, il utilise un système de poupées russes (Tor est notamment un acronyme : "The Onion Router", le routeur en oignon), qui va permettre de cacher les informations voulues, en se basant sur des serveurs un peu partout dans le monde, qui peuvent être chez des gens, des universités, etc. Et comme c'est pas très simple à expliquer, on va faire quelque chose de visuel.

**\[ Se mettre derrière la table, et expliquer le trajet navigateur -> truc.fr \]**

Mettons que je sois le navigateur Tor. L'humaine vient de me demander d'aller chercher la page d'accueil de truc.fr, et l'afficher. Je vais donc écrire une carte postale à destination de truc.fr pour lui demander **\[ montrez la carte postale \]**. D'ordinaire, sur tous les navigateurs, c'est à peu près ça qu'il se passe, la carte postale est envoyée en l'état par la Poste (Internet donc), et tous les intermédiaires peuvent lire et enregistrer ce qu'il y a écrit sur cette carte postale. Mais comme je suis Tor, j'ai pas envie que ça se passe comme ça, donc je vais mettre ma carte postale dans une boite **\[ mettre la carte postale dans la boite la plus petite \]**, puis dans une 2e boîte **\[ mettre la petite boîte dans la moyenne boîte \]**, puis pour être bien sûre, dans une 3e boîte **\[ mettre la moyenne dans la grande, et la poser au niveau de l'affiche "navigateur Tor" \]**. Voilà. Tout ça, c'est moi qui l'ai fait, moi le navigateur.

Sur ma grosse boite, il y a un expéditeur de noté, "moi", et une adresse : "Noeud Tor 1". J'envoie donc ça à Noeud Tor 1 **\[ poser la grosse boite au niveau de l'affiche "noeud tor 1" \]**, qui voit que ça vient de moi, et qu'il est bien le destinataire de ce colis, donc il l'ouvre. **\[ ouvrir la grosse boîte, la laisser à côté de l'affiche 'navigateur', et prendre la moyenne boite \]**. Là il trouve un 2e colis, et il voit qu'il en est l'expéditeur, donc il doit l'envoyer. Et à qui, et bien c'est marqué "Noeud Tor 2", donc il fait ça. **\[poser la moyenne boite à côté de la grosse, au niveau de l'affiche correspondante\]**. Noeud Tor 2 reçoit un paquet, et voit qu'il est bien le destinataire, donc il peut l'ouvrir. Et dans son paquet, il voit un autre paquet, sur lequel est marqué "expéditeur : Noeud 2", donc il est supposé envoyer ce colis, et à qui, et bien c'est marqué "destinataire : Noeud 3". Donc il fait ça. **\[poser la petite boite à côté de la moyenne\]**. Noeud Tor 3 reçoit donc son colis, où il voit qu'il est le destinataire, donc il l'ouvre. Et dedans, il trouve une carte postale, qui est signée "Noeud Tor 3", donc il sait qu'il doit l'envoyer, et à qui, et ben c'est noté, à "truc.fr". Donc il envoie cette carte postale à truc.fr **\[mettre la carte postale au niveau de truc.fr\]**. Truc.fr reçoit sa carte, lit ce qu'il doit faire, et voit que c'est Noeud Tor 3 qui lui demande. Il sait donc que le contenu de sa page est destiné à Noeud Tor 3, il lui renvoit donc sa page. **\[prendre la feuille "page d'accueil" et la mettre au niveau de Noeud Tor 3\]**. Noeud Tor 3 a bien gardé sa boite en attendant d'avoir des nouvelles de truc.fr, donc il mets cette page d'accueil dans sa boite, et le renvoie à l'expéditeur, Noeud tor 2. **\[prendre la petite boite avec la page d'accueil dedans et la mettre au niveau de Noeud tor 2\]**. Noeud Tor 2 récupère la boite de noeud tor 3, et la remet dans sa boite, direction l'expéditeur, donc noeud tor 1 **\[remettre la petite boite dans la moyenne boite et la mettre au niveau de noeud Tor 1\]**. Noeud Tor 1 fait de même, et me renvoie ma grosse boite **\[remettre la grosse boite au niveau de navigateur Tor\]**, que je peux ouvrir pour pouvoir afficher le contenu.

Voilà, c'est globalement ça qu'il se passe quand on utilise Tor. Si quelqu'un·e ou une institution regarde ce qu'il se passe chez Noeud tor 2, iels ne verront que des paquets qui viennent d'un autre serveur, Noeud Tor 1, et vont vers un autre, Noeud tor 3. Et pareil chez Noeud Tor 3, on verra que Noeud Tor 2 communique avec truc.fr, mais on ne saura pas que ça vient de moi.

Vous avez des questions?

## **Jeu** : Anaé navigue avec Tor

### Scénario

Dans notre, histoire, on suit ensuite Anaé, qui démarre son Navigateur Tor, va sur nantes.indymedia.org, trouve un communiqué, puis le republie sur plein de sites d'infos, dont son blog perso (dont le nom de domaine a été acheté il y a 5 ans avec une CB à son nom)

À savoir que « Anaé » est un nom d'usage, non lié à son état-civil.

### Cartes

Voici 7 cartes infrastructures suplémentaires, les positionner !

1. **ordi perso Anaé**
2. **box Anaé**

   ***FAI Orange (déjà sur place)***
3. **Tor noeud entrée**
4. **Tor noeud milieu**
5. **Tor noeud de sortie**

   ***Nantes.indymedia.org (déjà sur place)***
6. **stuut.info (mutu)**
7. **serveur wordpress.com**

   **câbles *(feutre)***

### **Correction**

**\[ Affichage au mur (avec des cartes au grand format par exemple) (voir le schéma corrigé) \]**

## **Quelles données concernant Anaé sont accessibles pour la police ?**

**\[ Au mur, ajouter les données en dessous des grosses cartes (uniquement les données auquel la police peut avoit accès) \]**

- Nantes.indymedia.org: 
  - ne répond pas aux requêtes et ne peut pas être saisi (stocké aux US)
- Sites mutu: 
  - même chose
- Wordpress: 
  - site créé par anae@riseup.net le 30 avril 2017 depuis l'IP 45.145.166.104 (*adresse noeud Tor*)
  - le communiqué a été publié depuis l'adresse IP 104.192.1.138 (*adresse noeud Tor*)
- Registrar: 
  - dernier paiement depuis l'identitifants BTC 1orByUa6D2xI28RlUgnNP3UxPQKcr7nZQ0;
  - premier paiement fait le 22 février 2016 par Carte bancaire nom Jérôme Vohan, numéro 4506791474896255, expire le 02/19.
- Nœud de sortie Tor: 
  - aucune info. (Si compromis par la police en question), lien entre activité de sortie et nœud du milieu) (mais c'est particulièrement improbable)
- Nœud du milieu (uniquement si le nœud de sortie ET le nœud du milieu sont compromis par la même police): 
  - liens avec le nœud d'entrée (mais c'est particulièrement improbable)
- Nœud d'entrée Tor (uniquement si le nœud de sortie ET du milieu ET d'entrée sont compromis): 
  - adresse IP utilisée (donc tel FAI) (mais c'est particulièrement improbable)
- FAI: 
  - pas de demande d'infos car les flics n'ont pas l'IP d'Anaé
- Perquisition : 
  - les flics peuvent envisager de perquisitionner la personne ayant payé le nom de domaine blog-anonyme.com en 2016 (Jérôme Vohan) car l'info leur a été donnée par le registrar

# Partie 4

## **Théorie** : Tails

**\[Cette partie repose sur la description de l'acronyme comme fil conducteur, + une projection en direct de l'écran de Tails (les étapes importantes de démarrage, les logiciels qui permettent de créer un espace persistant et de créer par duplication une clef Tails).\]**

*Tails* c'est un système d'exploitation complet portable, qui protège contre la surveillance et la censure. Il est développé et entretenu par des personnes militantes, et est fait pour être utilisé au maximum par tout le monde, peu importe le niveau technique en informatique de la personne. Sympa. Il est financé par des dons de particuliers et d'organismes.

Le nom Tails est au départ un acronyme dont les lettres importantes décrivent ses objectifs : The Amnesic Incognito Live System.

- S(ystem) : Tails est autonome et n'a pas besoin que Windows, Linux ou Mac soient installés sur l'ordinateur pour fonctionner, *il n'utilise que la mémoire vive de l'ordinateur, pas le disque dur.*
- L(ive) : Tails fonctionne sur la plupart des ordinateurs (pas les Mac récents) et démarre depuis une clef USB, il peut donc être emmené un peu partout et utilisé n'importe où, transformant possiblement tout ordinateur ou presque en un ordinateur plus sécurisé pour certains besoins.
- A(mnesic) : Tails ne laisse pas de traces dans l'ordinateur, et il n'y a pas de données personnelles stockées sur la clef USB (sauf si on le fait exprès).
- I(ncognito) : Tails protège l'anonymat des utilisateurices en passant par le réseau Tor pour accéder à internet.

On va vous montrer à quoi ça ressemble.

**\[À partir de là, on peut faire une démonstration face aux gens pour que tout le monde voit à quoi ça ressemble et comment on fait. On propose de montrer le démarrage, dérouler le menu pour voir les différents logiciels, s'arrêter sur le logiciel de clonage de Tails ainsi que sur le stockage persistant.\]**

Pour démarrer Tails, il faut savoir comment démarrer son ordinateur via la clé USB, c'est la plupart du temps un raccourci qui varie selon les marques *(cela implique de pouvoir intervenir lors de la séquence de démarrage dite de "boot" et donc de désactiver par exemple des options de "fast boot" qui ne permettent pas de démarrer sur une clé usb, notamment sur Windows).*

Dans les faits, il y a un coût d'entrée tout de même non négligeable pour utiliser Tails, et malgré toute la bonne volonté des personnes qui développent Tails. Un ordinateur, ça reste un truc compliqué pour plein de gens, et c'est pas les industriels, Windows, ou Apple, qui simplifient la tâche, loin de là. Selon votre ordinateur, ou si vous changez d'ordinateur régulièrement pour utiliser Tails, ça peut être chiant de prendre le coup de main et d'arriver à démarrer l'ordi sur la clé Tails. Mais L'avantage, c'est que c'est pas dur, comme manip, souvent faut juste savoir sur quel bouton appuyer.

Tails est fait par et pour des activistes, et vient avec beaucoup de logiciels utiles pour les luttes sociales : suite bureautique, logiciels de dessin et de mise en page pour faire des affiches, des tracts et des brochures, navigateur web, logiciel de courriels et de discussions instantanées. Il intègre toute une panoplie d'outils pour protéger la confidentialité des documents et l'identité des personnes qui les produisent, comme par exemple un nettoyeur de métadonnées.

Pour faciliter la diffusion et le partage de Tails, il intègre un outil de création de clefs Tails.

Si vous souhaitez conserver des documents et des paramètres d'une utilisation à l'autre de Tails, il est possible d'activer un espace de stockage chiffré appelé "Persistance". Lors du prochain démarrage de votre clé, on verra par contre qu'il y a des données protégées par un mot de passe.

## **Jeu** : Momo utilise Tails

### Scénario

Passons maintenant à Momo, qui est rentré⋅e chez ellui à 4h du mat' après être allé faire un tour à la cimenterie. Iel a choppé son ordi, a branché et démarré sa clé Tails, s'est connecté⋅e à la box du voisin et s'est rendu⋅e sur nantes.indymedia.org pour y publier un communiqué de son action nocturne.

### Cartes

Voici des cartes infrastructures, positionnez-les!

1. **ordi perso Momo**
2. **Clé Tails *(créer une carte transparente à l'aide d'un rodoïde rouge pour mettre par-dessus l'ordi, ça fait super gadget-mais-class)***
3. **box voisin**
4. **FAI Free**

   ***Tor1 (déjà en jeu)***

   ***Tor2 (déjà en jeu)***

   ***Tor3 (déjà en jeu)***

   ***nantes.indymedia.org (déjà en jeu)***

   ***Câbles (feutres)***

### **Correction**

**\[ Affichage au mur (avec des cartes au grand format par exemple) (voir le schéma corrigé) \]**

## **Quelles données concernant momo sont accessibles pour la police ?**

**\[ Au mur, ajouter les données en dessous des grosses cartes (uniquement les données auquel la police peut avoit accès) \]**

- Indy Nantes: 
  - ne répond pas aux requêtes + serveur aux US
- Saisie: (mais pourquoi les flics feraient une saisie chez momo?) 
  - utilise Tails, puis si persistence demande des codes de déverrouillage
- FAI: 
  - momo n'a pas de FAI
- FAI du voisin: (mais pourquoi les flics demanderaient quoi que ce soit au FAI du voisin?) 
  - (utilise Tails), utilise Tor

__Rappel: momo a pu être vu par une caméra qui amènent les flics chez lui (le plan de momo n'est pas parfait, il n'existe pas de plan parfait)__

# Partie 5

## **Théorie** : mails

### Fonctionnement des mails :

Un élément important pour comprendre comment est structuré Internet, c'est trois notions qui sont liées : le pair-à-pair, la fédération et la centralisation. C'est 3 manières de concevoir comment s'échangent et sont stockées les données.

Voilà une explication schématique.

La **centralisation**, c'est comme WhatsApp fonctionne, par exemple, ou Signal. On ne peut pas communiquer avec un·e utilisatrice·eur de WhatsApp en utilisant Signal, alors même que ces deux applications font globalement la même chose. *Ce qu'il se passe, c'est que même si 2 fournisseurs de services font à peu près la même chose du point de vue de l'utilisatrice·eur, les serveurs d'un service sont gérés par une seule entité, non-ouverte et non-rejoignable. Cette entité centralise la gestion des communications. Parce que c'est tellement mieux de faire sans les autres... De ne pas avoir la contrainte de devoir se mettre d'accord avec les autres, de devoir être transparent sur ce qu'on fait de ses données... Les GAFAM et compagnie adorent. Mais les services centralisés demandent à construire un réseau solide, pour être fonctionnels. Ainsi, si je suis la·e seul·e à utiliser Diaspora (l'équivalent libre de Facebook), ça ne fonctionnera pas...*

C'est clair?

La **fédération**, c'est les mails. On est pas obligé d'avoir un @gmail.com pour communiquer avec un @gmail.com, par exemple. C'est parce que les structures ont majoritairement fais des choix qui leur permettent de communiquer ensemble. *Ainsi, Machinou qui a @riseup.net peut envoyer un mail à Trucmuche qui a un mail mailo.org. C'est ce qui rend ce service beaucoup plus appropriable par un grand nombre. Les gens n'ont pas à télécharger une appli spécifique ou s'adapter à un nouvel outil, iels utilisent le client mail / client de messagerie qu'iels veulent.*

C'est clair?

Le **pair à pair**, c'est encore différent. Une très bonne image, c'est les appels téléphoniques. c'est deux interlocuteurices qui communiquent directement, sans avoir à passer les messages à une structure intermédiaire qui stockera puis relayera l'info. Ça veut dire que si on fait de la communication en pair·e à pair·e, les messages ne seront stockés normalement nulle part d'autre que chez les deux personnes. Ça veut aussi dire que les deux personnes doivent être connectées en même temps si elles veulent pouvoir communiquer.

*Ça peut aussi servir en service de communication instantanée, et c'est aussi très connu aussi pour télécharger des films, de la musique, etc illégalement. Et c'est pour ça que c'est conseillé d'utiliser un VPN ou un proxy quand on fait du pair·e à pair·e, parce que l'identité des personnes qui sont connectées ensemble est très claire, donc si on voit que la personne qui stocke des films les partage également, l'ARCOM (anciennement Hadopi, définir si c'est pas clair) lui tombe dessus, puisque la personne qui télécharge le film est identifiable. Le VPN/proxy fera office d'intermédiaire, et s'il est de confiance permettra de ne pas risquer d'être poursuivi·e.*

C'est clair?

Encore une fois, c'est schématisé, donc globalement ça fonctionne comme ça, même s'il peut y avoir des variations (parce que l'informatique, vous l'aurez deviné, c'est rarement simple). L'intérêt de savoir tout ça, c'est pour pouvoir comprendre qu'il existe des systèmes différents, et pouvoir ainsi faire des choix un peu plus éclairés sur les services qu'on veut utiliser. Parce qu'utiliser des outils qui permettent une sécurisation très forte, ça demande encore malheureusement plus de temps, plus de connaissances et compétences, et donc c'est pas accessible à tout le monde. Les groupes qui choisissent de changer leurs outils numériques se heurtent souvent à des inégalités face à l'hostilité de la technique, mais aussi aux compromis différents qui peuvent exister au sein du groupe et qui ne sont pas toujours discutés, les capacités à s'autoévaluer, etc etc...

Tout ça pour dire que Nando, dans notre scénario, n'est pas à blâmer (sauf si iel a 30 ans d'expérience dans le hacking et bac+12 en sécurisation, là ok...), et Momo n'est pas la star. Il n'y a pas de jugement à porter sur les personnes, mais sur les système en place, et notre énergie doit être dirigée vers la manière de faire en sorte que Nando, autant que les autres, soient le plus protégé·es possible dans leurs vies perso, pro, collectives et militantes.

## Jeu : échange de mails

### Scénario

L'enquête avance, les flics ont des soupçons sur Nando et approfondissent les recherches du côté de son adresse mail qu'iels ont choppé grâce à facebook.

Une requête est faite à Gmail -> n.karimata@gmail.com a envoyé pas mal de mails à Ilian (ilianeektoo@riseup.net)

### Cartes

**Voici des cartes infrastructures, positionnez-les!**

1. **ordi perso Ilian**
2. **box Ilian**
3. **FAI FDN**
4. **serveur gmail.com**
5. **serveur mail.riseup.net**

   ***ordi perso Nando + box + FAI (déjà sur place)***

   ***câbles (feutres)***

### Correction

**\[ Affichage au mur (avec des cartes au grand format par exemple) (voir le schéma corrigé)\]**

## Quelles données sont accessibles pour la police ?

**\[ Au mur, ajouter les données en dessous des grosses cartes (uniquement les données auquel la police peut avoit accès) \]**

- gmail: donne à la police le contenu des mails de n.karimata@gmail.com à ilianeektoo@riseup.net
- riseup: ne répondent pas à la requête

# Partie 6

## Théorie : chiffrement de mail

**\[ Cette fois encore, selon la motiv ça peut super bien marcher de créer un support visuel. Là ce serait une enveloppe avec un cadenas dessiné dessus et au dos des données de connection, une feuille avec bonjour marqué dessus, un papier avec une clé dessiné dessus. Pour le détail de ce qu'il y a à marquer, voir dans l'explication ci-dessous.\]**

Alors, une possibilité pour réduire les risques que Nando et Ilian aient leurs conversations lues par la police (ou par n'importe qui d'autre), ce serait de chiffrer leurs mails. En soi, il aurait pu y avoir les deux personnes qui utilisent Riseup, ou un autre fournisseur mail de confiance et ça aurait limité la casse, mais le mieux c'est quand même de ne pas avoir __besoin__ de faire confiance à notre fournisseur mail.

Comment ça marche: Comme on l'a dit au début, chiffrer ça veut dire rendre une information illisible aux personnes n'ayant pas les clés pour la lire, c'est remplacer temporairement une information par une suite illogique de chiffres et de lettres (logique uniquement pour le·a destinataire et l'émetteurice ou le·a destinataire).

Aujourd'hui ça marche la plupart du temps avec un système clé publique/clé privé: La **clé publique** c'est comme une enveloppe cadenassée, la **clé privée** c'est la clé qui peut l'ouvrir. Tu peux distribuer ta clé publique, c'est comme si tu donnais un modèle d'enveloppe cadenassée aux gens qu'iels peuvent reproduire à l'infini. Iels peuvent mettre leur message dedans et fermer le cadenas (c'est à dire dans notre situation, chiffrer le message) et tu seras la seule à pouvoir ouvrir l'enveloppe (avec la clé privée) pour accéder au message.

Donc en résumé **\[s'aider du schéma d'internet et des ordis connectés ensemble ça peut être utile\]** : Machin envoie sa clé publique à Truc (par mail non chiffré, ou via une clé usb, n'importe). Truc écrit un message, utilise le cadenas, donc la clé publique de Machin pour chiffrer son message, et l'envoie à Machin. Machin reçoit son message chiffré, que personne n'a pu lire, et le déchiffre avec la clé privée qui correspond au cadenas utilisé.

/!\\ Dans cette situation, pour l'instant Machin peut recevoir des mails chiffrés, mais ne peut pas en écrire à Truc, vu que Truc ne lui a pas envoyé sa clé publique (son cadenas!). Il faudra que Truc lui envoie pour que Machin puisse répondre de manière chiffrée. À savoir que plein d'outils fonctionnent comme ça sur internet, et que pour l'utilisation des mails, ça se fait quasi automatiquement quand on utilise un gestionnaire de mails, par exemple (Thunderbird, vous connaissez?)

Revenons sur notre système. Donc si on fait tout ça, le contenu du mail est chiffré, ok, mais comme tout à l'heure pour Tor, il faut bien des infos qui permettent d'indiquer par exemple où aller et de qui ça vient, pendant le chemin au travers d'internet, sinon ça marche pas. Au dos de notre enveloppe, il y a donc des infos qui sont lisibles par tous les intermédiaires: de quelle box ça vient, ça va vers quelle box, mais aussi les données de connection (à quelle date et heure la lettre a été envoyée, ...).

Donc on voit que chiffrer les mails peut clairement limiter la casse, mais que ça n'enlève pas tout ; la police peut (si iels sont motivé·es bien sûr, ce n'est pas magique), savoir que telle adresse communique avec telle autre, et potentiellement relier une adresse à une box et donc très souvent, à une identité civile. Utiliser Tor dans ce contexte, ça veut dire réduire les informations intéressantes pour la police.

Des questions?

# *Partie 7*

## *Théorie : Chiffrement de données "au repos"*

*Intro:*

*Rappel définition cryptographie, chiffrement et cryptanalyse:*

- *La cryptographie est la branche des mathématiques qui s'occupe spécifiquement de protéger des messages/données.*
- *Le chiffrement est un procédé cryptographique grâce auquel on souhaite rendre la compréhension d'un document impossible à toute personne qui n'a pas la clé de (dé)chiffrement. C'est un des meilleurs moyens qu'on a à notre disposition pour nous protéger en ligne.*

  *(À savoir que jusqu'en 1999, l'usage des techniques cryptographiques était interdit au grand public ou alors fortement réglementée.)*

*Les méthodes de chiffrement qui sont utilisées ne sont pas incassables, il y a des exemples qui existent et disent le contraire.*

*On peut considérer un algorithme de chiffrement comme étant sûr en fonction de plusieurs critères, mais en gros il est plus sûr si :*

- *si ça fait longtemps qu'il est utilisé*
- *Beaucoup de cryptographes ont analysé sa robustesse et après plusieurs années n'ont pas trouvé de failles.*
- *Que tout l'algorithme soit ouvert et connu de toustes*
- *Que la robustesse de l'algorithme ne tient pas au fait qu'on ne sache pas quel algorithme est utilisé. (principe de Kerchkoff)*

*La vraie question c'est pas tant ''est ce que les méthodes de chiffrement sont cassables', mais plutôt 'est-ce que ça augmente suffisamment le coût de la surveillance''.*

*-> si ça met des millions d'années à déchiffrer le fichier (donc avoir des capacités de calcul VRAIMENT conséquentes pour réduire cette durée)*

*-> augmenter le coût de la surveillance à intérêt collectif (même chose que pour Tor, ou toute autre pratique de sécurité)*

*-> chiffrer des trucs pas sensibles (l’intégrale de Steven Universe sur un disque dur externe par exemple), ça fait que même si c’est déchiffré c’est pas grave, et ça prend quand même beaucoup de temps, d’argent, etc)*

*__Chiffrement des données sur un disque dur/clé usb :__* 

*- Dans le cas précis du chiffrement d'un support de stockage (usb, carte SD, disque physique ou virtuel), c’est le système d'exploitation qui se charge de gérer les opérations de chiffrement et de déchiffrement, à la volée.*

*Définition du chiffrement à la volée : maintenant, la majorité du chiffrement se fait petit bout par petit bout : le système d’exploitation déchiffre chaque donnée désirée, et la rechiffre juste après. Ça prend un chouilla plus de temps, mais au moins tout est chiffré tout le temps.*

*Cool ! MAIS : pour que les opérations de chiffrement à la volée se fassent correctement, il faut que la clé de chiffrement/déchiffrement se trouve en mémoire vive aussi longtemps que le support (disque, clé usb) a besoin d'être utilisé.*

*(Petit rappel: La mémoire vive sert à stocker tous les logiciels et documents ouverts lorsque l'ordinateur est allumé, donc toutes les informations traitées par l'ordinateur passent par la mémoire vive sous une forme directement utilisable -donc non chiffrée.)*

*DONC, une fois les données déchiffrées, ces dernières se trouvent au minimum dans la mémoire vive, laquelle a besoin de la clé de déchiffrement qui y est donc également.*

*→ Dans le cas ou quelqu’un·e obtient un accès physique à l'ordinateur allumé, alors iel a de fait accès au contenu de la mémoire vive et donc peut copier les clés de déchiffrement, mais aussi  toutes les données sur lesquelles on a travaillé depuis l'allumage de l'ordinateur, non chiffrées (car pas sur le disque dure mais dans la mémoire vive).*

*→ De plus, le système d'exploitation qu'on utilise a, on l’a déjà dit, accès aux données et à la clé de déchiffrement autant que nous, alors tout dépend de la confiance qu'on leur accorde. Donc faire attention à installer que des logiciels en qui on a confiance.*

*-> Il vaut donc mieux prendre l'habitude d'éteindre les ordinateurs et de débrancher les disques chiffrés quand on ne s'en sert pas.*

*Exemples de trucs qui peuvent se chiffrer / qui se chiffrent :*

- *La persistance de Tails*
- *Android (sur beaucoup de téléphones depuis 2017) et iOS (depuis 2014)*
- *Des systèmes d’exploitation (Debian / Fedora / Ubuntu / Linux Mint (optionnel à l'installation)), même mainstream (Windows (optionnel à l'installation ou après l'installation))*

*Résumé et limites du chiffrement:*

*Bien qu'il soit un outil puissant et essentiel pour la sécurité des informations, le chiffrement a ses limites, qu'il faut bien avoir à l'esprit quand on l'utilise, sinon on risque de penser qu'on est invincible puis on fait des dingueries.*

*Il faut notamment faire méga attention aux éléments suivants:*

*- Bien penser à la mémoire vive, et donc éteindre son ordinateur quand il n’est pas utilisé.*

*- Attaquer un disque débranché c'est dur, mais il reste possible qu'un enregistreur de frappe (keylogger en anglais) physique ou logiciel ait pu été installé sur l'ordinateur, et que celui-ci enregistre la phrase de passe.*

*- Parfois, nos mots de passe sont nuls, et donc sont retrouvables hyper facilement (un ordinateur puissant essaye très très vite tout un tas de mots et combinaisons pour pouvoir trouver le mot de passe (donc "chaton" ça résiste pas bien longtemps, quoi...)*

*- En France, il y a aussi un aspect légal: toute personne qui chiffre ses données est sensée donner le code aux autorités judiciaires (article  434-15-2 du code pénal)*

*- Et puis on peut aussi le récupérer en étant violent, pas forcément besoin de dépenser des millions en cryptotruc, mettre des coups de pression ou un pain dans la tronche, ça peut être suffisant.*

*Et tout ça, à quel modèle de menace ça répond?*

*Bien évidemment, pas tout le monde n’est susceptible de se faire péter la gueule pour récupérer des données numériques, heureusement. L’important est de voir cet outil comme utile pour tout un tas de situations, mais toujours à adapter selon le contexte. Globalement, le chiffrement peut répondre à des menaces de la part de :*

- *cohabitant·es ou voisaine malveillant·e*
- *vol ou perte*
- *police/services de renseignement*
- *perquisition*
- *frontières*

# Conclusion

Il n'y a pas de sécurité, mais qu'une illusion de sécurité.

On peut parler de prévention et de réduction des risques, on peut se sentir un peu plus serein·e, mais jamais 0 risque.

Attention à comment on choisit nos outils, attention à la confiance qu'on peut avoir dans certains outils et créateurices/administratriceurs d'outils.  C'est ensemble qu'on se sécurise, seul·e, ça ne marche pas.

**\[ + résumer les réactions, points compliqués pour les gens. \]**